################################################################################
###Creating Heatmaps############################################################


### the first time, you need to install these packages (remove # and press Strg+Enter):
install.packages("tidyverse")
install.packages("readxl")
install.packages("RColorBrewer")
install.packages("pheatmap")
install.packages("ggplot2")


### load these packages always when you start the program
library(readxl)
library(RColorBrewer)
library(pheatmap)
library(tidyverse)
library(ggplot2)



### name your first dataset and define the location and the EXCEL sheet. Important: unse / and not \

data_Inflammasome_1 <- read_excel("B:/FuL/TRANSLATIONALE_MIBI/lab-member/Yasmina/4_Experiments/TERC_mice/T cells/Heatmaps/Heatmap_Inflammasome.xlsx", 
                    sheet = "Tabelle2")


### define your column with the gene name as text and 
### define the columns containing values that you want to show (4:9 means column 4-colum 9).
### You ned to create a new dataset for this. 

data_Inflammasome_2 <- data_Inflammasome_1 %>%
  select("gene_name", 4:7) %>%
  column_to_rownames(var = "gene_name")


### create the heatmap. 
### Use the breaks = seq(min(-4.0), abs(min(4.0)) to adjust the min/max value that is shown.
### cluster_cols and cluster_rows are used for the hierachical clustering. Say FALSE if you do not want to have it.


heatmap_data_Inflammasome_1 <- pheatmap(data_Inflammasome_2, color = colorRampPalette(rev(brewer.pal(n = 7, name ="RdBu")))(100),
                                     cluster_cols = TRUE, cluster_rows = TRUE, scale = "none", cellwidth = 25, cellheight =9, 
                                     breaks = seq(min(-4.0), abs(min(4.0)), length.out = 101), 
                                     labels_col = c("Tercko/ko mock vs Old mock", "Tercko/ko S. aureus vs Young S. aureus",
                                                    "Tercko/ko S. aureus vs Old S. aureus", "Tercko/ko S. aureus vs Tercko/ko mock"), 
                                     fontsize_row = 8,
                                     fontsize_col = 11,
                                     na_col = "#a8a8a8",
                                     angle_col = c("45"),
                                     cutree_rows = 4,
                                     main = "NLRP3 Inflammasome signalling")


